
<?php $__env->startSection('title', 'Task Details'); ?>
<?php $__env->startSection('page-title', 'Task Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="row g-3">
    <!-- Main Task Info -->
    <div class="col-md-8">
        <div class="card mb-3">
            <div class="card-header py-3 d-flex justify-content-between align-items-center">
                <span><i class="bi bi-file-earmark-text me-2"></i>Task Information</span>
                <div class="d-flex gap-2">
                    <span class="badge status-<?php echo e($task->status); ?> fs-6">
                        <?php echo e(str_replace('_', ' ', ucfirst($task->status))); ?>

                    </span>
                    <span class="badge bg-<?php echo e($task->priorityBadge()); ?>"><?php echo e(ucfirst($task->priority)); ?> Priority</span>
                </div>
            </div>
            <div class="card-body">

                
                <?php if($task->parent_task_id && $task->parentTask): ?>
                <div class="alert alert-info py-2 mb-3 d-flex align-items-center gap-2">
                    <i class="bi bi-link-45deg fs-5"></i>
                    <div>
                        <strong>Marketing Processing Task</strong> — originated from:
                        <a href="<?php echo e(route('tasks.show', $task->parentTask)); ?>" class="fw-semibold ms-1">
                            <?php echo e($task->parentTask->title); ?>

                        </a>
                        <span class="badge bg-success ms-1">Approved</span>
                    </div>
                </div>
                <?php endif; ?>

                
                <?php if($task->marketingTask): ?>
                <div class="alert alert-success py-2 mb-3 d-flex align-items-center gap-2">
                    <i class="bi bi-arrow-right-circle fs-5"></i>
                    <div>
                        <strong>Marketing task created:</strong>
                        <a href="<?php echo e(route('tasks.show', $task->marketingTask)); ?>" class="fw-semibold ms-1">
                            <?php echo e($task->marketingTask->title); ?>

                        </a>
                        <span class="badge status-<?php echo e($task->marketingTask->status); ?> ms-1">
                            <?php echo e(str_replace('_', ' ', ucfirst($task->marketingTask->status))); ?>

                        </span>
                    </div>
                </div>
                <?php endif; ?>

                <h5 class="fw-bold mb-3"><?php echo e($task->title); ?></h5>

                <?php if($task->description): ?>
                <p class="text-muted"><?php echo e($task->description); ?></p>
                <hr>
                <?php endif; ?>

                <div class="row g-3">
                    <div class="col-sm-6">
                        <div class="p-3 bg-light rounded">
                            <div class="text-muted small mb-1">Assigned To</div>
                            <div class="d-flex align-items-center gap-2">
                                <div class="avatar"><?php echo e(strtoupper(substr($task->assignedUser->name, 0, 1))); ?></div>
                                <div>
                                    <div class="fw-semibold"><?php echo e($task->assignedUser->name); ?></div>
                                    <span class="role-badge role-<?php echo e($task->assignedUser->role); ?>">
                                        <?php echo e(str_replace('_', ' ', $task->assignedUser->role)); ?>

                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="p-3 bg-light rounded">
                            <div class="text-muted small mb-1">Created By</div>
                            <div class="d-flex align-items-center gap-2">
                                <div class="avatar" style="background:#6f42c1;">
                                    <?php echo e(strtoupper(substr($task->createdByUser->name, 0, 1))); ?>

                                </div>
                                <div>
                                    <div class="fw-semibold"><?php echo e($task->createdByUser->name); ?></div>
                                    <small class="text-muted"><?php echo e($task->created_at->format('d M Y')); ?></small>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="text-muted small">Planned Start</div>
                        <div class="fw-semibold"><?php echo e($task->planned_start->format('d M Y')); ?></div>
                    </div>
                    <div class="col-sm-3">
                        <div class="text-muted small">Planned End</div>
                        <div class="fw-semibold <?php echo e($task->isOverdue() ? 'text-danger' : ''); ?>">
                            <?php echo e($task->planned_end->format('d M Y')); ?>

                            <?php if($task->isOverdue()): ?> <span class="badge bg-danger ms-1">Overdue</span> <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="text-muted small">Actual Start</div>
                        <div class="fw-semibold">
                            <?php echo e($task->actual_start ? $task->actual_start->format('d M Y h:i A') : '—'); ?>

                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="text-muted small">Actual End</div>
                        <div class="fw-semibold">
                            <?php echo e($task->actual_end ? $task->actual_end->format('d M Y h:i A') : '—'); ?>

                        </div>
                    </div>
                </div>

                <?php if($task->attachment): ?>
                <div class="mt-3">
                    <div class="text-muted small mb-1">Attachment</div>
                    <a href="<?php echo e(Storage::url($task->attachment)); ?>" target="_blank" class="btn btn-sm btn-outline-info">
                        <i class="bi bi-paperclip me-1"></i> View Attachment
                    </a>
                </div>
                <?php endif; ?>

                <?php if($task->status === 'rejected' && $task->rejection_reason): ?>
                <div class="alert alert-danger mt-3">
                    <i class="bi bi-exclamation-triangle me-2"></i>
                    <strong>Rejection Reason:</strong> <?php echo e($task->rejection_reason); ?>

                </div>
                <?php endif; ?>
            </div>

            <!-- Action Buttons -->
            <div class="card-footer d-flex gap-2 flex-wrap">
                <?php if($task->assigned_to === auth()->id() || auth()->user()->canManageTasks()): ?>
                    <?php if($task->status === 'pending'): ?>
                    <form action="<?php echo e(route('tasks.start', $task)); ?>" method="POST">
                        <?php echo csrf_field(); ?> <?php echo method_field('PATCH'); ?>
                        <button class="btn btn-success">
                            <i class="bi bi-play-fill me-1"></i>Start Task
                        </button>
                    </form>
                    <?php elseif($task->status === 'in_progress'): ?>
                    <form action="<?php echo e(route('tasks.complete', $task)); ?>" method="POST">
                        <?php echo csrf_field(); ?> <?php echo method_field('PATCH'); ?>
                        <button class="btn btn-warning">
                            <i class="bi bi-stop-fill me-1"></i>Mark Complete & Submit for Review
                        </button>
                    </form>
                    <?php elseif($task->status === 'rejected'): ?>
                    <form action="<?php echo e(route('tasks.start', $task)); ?>" method="POST">
                        <?php echo csrf_field(); ?> <?php echo method_field('PATCH'); ?>
                        <button class="btn btn-primary">
                            <i class="bi bi-arrow-repeat me-1"></i>Re-start Task
                        </button>
                    </form>
                    <?php endif; ?>
                <?php endif; ?>

                <?php if(auth()->user()->canApprove() && $task->status === 'under_review'): ?>
                <!-- Approve Modal Trigger -->
                <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#approveModal">
                    <i class="bi bi-check-circle me-1"></i>Approve Task
                </button>
                <button class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#rejectModal">
                    <i class="bi bi-x-circle me-1"></i>Reject Task
                </button>
                <?php endif; ?>

                <?php if(!in_array($task->status, ['approved', 'completed'])): ?>
                <a href="<?php echo e(route('tasks.edit', $task)); ?>" class="btn btn-outline-secondary">
                    <i class="bi bi-pencil me-1"></i>Edit
                </a>
                <?php endif; ?>

                <a href="<?php echo e(route('tasks.index')); ?>" class="btn btn-outline-secondary ms-auto">
                    <i class="bi bi-arrow-left me-1"></i>Back to Tasks
                </a>
            </div>
        </div>
    </div>

    <!-- Task Log / History -->
    <div class="col-md-4">
        <div class="card">
            <div class="card-header py-3">
                <i class="bi bi-clock-history me-2 text-info"></i>Activity Log
            </div>
            <div class="card-body p-0" style="max-height:500px;overflow-y:auto;">
                <?php $__empty_1 = true; $__currentLoopData = $task->logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="d-flex gap-3 p-3 border-bottom">
                    <div class="flex-shrink-0">
                        <span class="badge bg-<?php echo e($log->actionBadge()); ?>" style="width:12px;height:12px;border-radius:50%;padding:0;">&nbsp;</span>
                    </div>
                    <div>
                        <div class="fw-semibold small"><?php echo e($log->actionLabel()); ?></div>
                        <div class="text-muted" style="font-size:0.75rem;">
                            By <strong><?php echo e($log->user->name); ?></strong>
                        </div>
                        <?php if($log->note): ?>
                        <div class="text-muted" style="font-size:0.75rem;"><?php echo e($log->note); ?></div>
                        <?php endif; ?>
                        <div class="text-muted" style="font-size:0.7rem;"><?php echo e($log->created_at->diffForHumans()); ?></div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="text-center py-4 text-muted small">No activity yet.</div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Approval History -->
        <?php if($task->approvals->count() > 0): ?>
        <div class="card mt-3">
            <div class="card-header py-3">
                <i class="bi bi-clipboard-check me-2 text-success"></i>Approval History
            </div>
            <div class="card-body p-0">
                <?php $__currentLoopData = $task->approvals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $approval): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="p-3 border-bottom">
                    <div class="d-flex justify-content-between">
                        <span class="badge bg-<?php echo e($approval->status === 'approved' ? 'success' : 'danger'); ?>">
                            <?php echo e(ucfirst($approval->status)); ?>

                        </span>
                        <small class="text-muted"><?php echo e($approval->created_at->format('d M Y')); ?></small>
                    </div>
                    <div class="small mt-1">By: <strong><?php echo e($approval->reviewer->name); ?></strong></div>
                    <?php if($approval->comment): ?>
                    <div class="text-muted small mt-1"><?php echo e($approval->comment); ?></div>
                    <?php endif; ?>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>

<!-- Approve Modal -->
<?php if(auth()->user()->canApprove()): ?>
<div class="modal fade" id="approveModal" tabindex="-1">
    <div class="modal-dialog">
        <form action="<?php echo e(route('approvals.approve', $task)); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="bi bi-check-circle text-success me-2"></i>Approve Task</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <p>You are about to approve: <strong><?php echo e($task->title); ?></strong></p>
                    <div class="mb-3">
                        <label class="form-label">Comment (optional)</label>
                        <textarea name="comment" class="form-control" rows="3" placeholder="Add a comment..."></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-success">
                        <i class="bi bi-check-circle me-1"></i>Approve
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Reject Modal -->
<div class="modal fade" id="rejectModal" tabindex="-1">
    <div class="modal-dialog">
        <form action="<?php echo e(route('approvals.reject', $task)); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="bi bi-x-circle text-danger me-2"></i>Reject Task</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <p>You are about to reject: <strong><?php echo e($task->title); ?></strong></p>
                    <div class="mb-3">
                        <label class="form-label fw-semibold">Rejection Reason <span class="text-danger">*</span></label>
                        <textarea name="comment" class="form-control" rows="3"
                                  placeholder="Explain why this task is rejected..." required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-danger">
                        <i class="bi bi-x-circle me-1"></i>Reject Task
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH H:\xampp_8.0\htdocs\user_task\resources\views/tasks/show.blade.php ENDPATH**/ ?>