
<?php $__env->startSection('title', 'Team Members'); ?>
<?php $__env->startSection('page-title', 'Team Members'); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header py-3 d-flex justify-content-between align-items-center">
        <span><i class="bi bi-people me-2 text-primary"></i>Team Members</span>
        <?php if(auth()->user()->isSuperAdmin()): ?>
        <a href="<?php echo e(route('users.create')); ?>" class="btn btn-primary btn-sm">
            <i class="bi bi-person-plus me-1"></i> Add Member
        </a>
        <?php endif; ?>
    </div>

    <div class="card-body border-bottom py-3">
        <form method="GET" class="row g-2">
            <div class="col-md-4">
                <input type="text" name="search" class="form-control form-control-sm"
                       placeholder="Search by name or email..." value="<?php echo e(request('search')); ?>">
            </div>
            <div class="col-md-3">
                <select name="role" class="form-select form-select-sm">
                    <option value="">All Roles</option>
                    <?php if(!auth()->user()->isSuperAdmin()): ?>
                    <option value="super_admin" <?php echo e(request('role') === 'super_admin' ? 'selected' : ''); ?>>Super Admin</option>
                    <option value="admin"       <?php echo e(request('role') === 'admin' ? 'selected' : ''); ?>>Admin</option>
                    <?php endif; ?>
                    <option value="marketing"   <?php echo e(request('role') === 'marketing' ? 'selected' : ''); ?>>Marketing</option>
                    <option value="designer"    <?php echo e(request('role') === 'designer' ? 'selected' : ''); ?>>Designer</option>
                    <option value="developer"   <?php echo e(request('role') === 'developer' ? 'selected' : ''); ?>>Developer</option>
                </select>
            </div>
            <div class="col-md-2">
                <button type="submit" class="btn btn-secondary btn-sm">
                    <i class="bi bi-funnel me-1"></i>Filter
                </button>
            </div>
        </form>
    </div>

    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table mb-0">
                <thead>
                    <tr>
                        <th class="ps-3">Member</th>
                        <th>Email</th>
                        <th>Role</th>
                        <th>Phone</th>
                        <th>Status</th>
                        <th>Joined</th>
                        <?php if(auth()->user()->isSuperAdmin()): ?>
                        <th>Actions</th>
                        <?php endif; ?>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td class="ps-3">
                            <div class="d-flex align-items-center gap-2">
                                <div class="avatar role-<?php echo e($user->role); ?>" style="background:none;border:2px solid;">
                                    <?php echo e(strtoupper(substr($user->name, 0, 1))); ?>

                                </div>
                                <div>
                                    <div class="fw-semibold small"><?php echo e($user->name); ?></div>
                                    <?php if($user->username): ?>
                                    <div class="text-muted" style="font-size:0.75rem;"><?php echo e($user->username); ?></div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </td>
                        <td><small><?php echo e($user->email); ?></small></td>
                        <td>
                            <span class="role-badge role-<?php echo e($user->role); ?>">
                                <?php echo e(str_replace('_', ' ', $user->role)); ?>

                            </span>
                        </td>
                        <td><small class="text-muted"><?php echo e($user->phone ?? '—'); ?></small></td>
                        <td>
                            <span class="badge bg-<?php echo e($user->status === 'active' ? 'success' : 'danger'); ?>">
                                <?php echo e(ucfirst($user->status)); ?>

                            </span>
                        </td>
                        <td><small class="text-muted"><?php echo e($user->created_at->format('d M Y')); ?></small></td>
                        <?php if(auth()->user()->isSuperAdmin()): ?>
                        <td>
                            <div class="d-flex gap-1">
                                <a href="<?php echo e(route('users.edit', $user)); ?>" class="btn btn-sm btn-outline-warning" title="Edit">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                <?php if($user->id !== auth()->id()): ?>
                                <form action="<?php echo e(route('users.destroy', $user)); ?>" method="POST"
                                      onsubmit="return confirm('Delete <?php echo e($user->name); ?>? This cannot be undone.')">
                                    <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                    <button class="btn btn-sm btn-outline-danger" title="Delete">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </form>
                                <?php endif; ?>
                            </div>
                        </td>
                        <?php endif; ?>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" class="text-center py-5 text-muted">No members found.</td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php if($users->hasPages()): ?>
    <div class="card-footer"><?php echo e($users->links()); ?></div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH H:\xampp_8.0\htdocs\user_task\resources\views/users/index.blade.php ENDPATH**/ ?>