
<?php $__env->startSection('title', 'Tasks'); ?>
<?php $__env->startSection('page-title', 'Tasks'); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header py-3">
        <div class="d-flex justify-content-between align-items-center flex-wrap gap-2">
            <span><i class="bi bi-list-task me-2 text-primary"></i>
                <?php echo e(auth()->user()->canManageTasks() ? 'All Tasks' : 'My Tasks'); ?>

            </span>
            <a href="<?php echo e(route('tasks.create')); ?>" class="btn btn-primary btn-sm">
                <i class="bi bi-plus-circle me-1"></i> Create Task
            </a>
        </div>
    </div>

    <!-- Filters -->
    <div class="card-body border-bottom py-3">
        <form method="GET" class="row g-2 align-items-end">
            <div class="col-md-4">
                <input type="text" name="search" class="form-control form-control-sm"
                       placeholder="Search tasks..." value="<?php echo e(request('search')); ?>">
            </div>
            <div class="col-md-2">
                <select name="status" class="form-select form-select-sm">
                    <option value="">All Status</option>
                    <option value="pending" <?php echo e(request('status') === 'pending' ? 'selected' : ''); ?>>Pending</option>
                    <option value="in_progress" <?php echo e(request('status') === 'in_progress' ? 'selected' : ''); ?>>In Progress</option>
                    <option value="under_review" <?php echo e(request('status') === 'under_review' ? 'selected' : ''); ?>>Under Review</option>
                    <option value="approved" <?php echo e(request('status') === 'approved' ? 'selected' : ''); ?>>Approved</option>
                    <option value="rejected" <?php echo e(request('status') === 'rejected' ? 'selected' : ''); ?>>Rejected</option>
                </select>
            </div>
            <div class="col-md-2">
                <select name="priority" class="form-select form-select-sm">
                    <option value="">All Priority</option>
                    <option value="high" <?php echo e(request('priority') === 'high' ? 'selected' : ''); ?>>High</option>
                    <option value="medium" <?php echo e(request('priority') === 'medium' ? 'selected' : ''); ?>>Medium</option>
                    <option value="low" <?php echo e(request('priority') === 'low' ? 'selected' : ''); ?>>Low</option>
                </select>
            </div>
            <?php if(auth()->user()->canManageTasks()): ?>
            <div class="col-md-2">
                <select name="assigned_to" class="form-select form-select-sm">
                    <option value="">All Members</option>
                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($u->id); ?>" <?php echo e(request('assigned_to') == $u->id ? 'selected' : ''); ?>>
                        <?php echo e($u->name); ?>

                    </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <?php endif; ?>
            <div class="col-md-2">
                <button type="submit" class="btn btn-secondary btn-sm w-100">
                    <i class="bi bi-funnel me-1"></i> Filter
                </button>
            </div>
        </form>
    </div>

    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table mb-0">
                <thead>
                    <tr>
                        <th class="ps-3">#</th>
                        <th>Task Title</th>
                        <?php if(auth()->user()->canManageTasks() || auth()->user()->isMarketing()): ?>
                        <th>Assigned To</th>
                        <?php endif; ?>
                        <th>Priority</th>
                        <th>Planned Start</th>
                        <th>Planned End</th>
                        <th>Actual Start</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="<?php echo e($task->isOverdue() ? 'table-danger' : ($task->status === 'rejected' ? 'table-warning' : '')); ?>">
                        <td class="ps-3 text-muted small"><?php echo e($task->id); ?></td>
                        <td>
                            <a href="<?php echo e(route('tasks.show', $task)); ?>" class="fw-medium text-decoration-none">
                                <?php echo e(Str::limit($task->title, 40)); ?>

                            </a>
                            <?php if($task->isOverdue()): ?>
                            <span class="badge bg-danger ms-1" style="font-size:0.6rem;">OVERDUE</span>
                            <?php endif; ?>
                        </td>
                        <?php if(auth()->user()->canManageTasks() || auth()->user()->isMarketing()): ?>
                        <td>
                            <div class="d-flex align-items-center gap-1">
                                <div class="avatar" style="width:26px;height:26px;font-size:0.65rem;">
                                    <?php echo e(strtoupper(substr($task->assignedUser->name, 0, 1))); ?>

                                </div>
                                <span class="small"><?php echo e($task->assignedUser->name); ?></span>
                            </div>
                        </td>
                        <?php endif; ?>
                        <td>
                            <span class="badge bg-<?php echo e($task->priorityBadge()); ?>"><?php echo e($task->priority); ?></span>
                        </td>
                        <td><small><?php echo e($task->planned_start->format('d M Y')); ?></small></td>
                        <td>
                            <small class="<?php echo e($task->isOverdue() ? 'text-danger fw-bold' : ''); ?>">
                                <?php echo e($task->planned_end->format('d M Y')); ?>

                            </small>
                        </td>
                        <td>
                            <small class="text-muted">
                                <?php echo e($task->actual_start ? $task->actual_start->format('d M Y') : '—'); ?>

                            </small>
                        </td>
                        <td>
                            <span class="badge status-<?php echo e($task->status); ?>">
                                <?php echo e(str_replace('_', ' ', ucfirst($task->status))); ?>

                            </span>
                        </td>
                        <td>
                            <div class="d-flex gap-1 flex-wrap">
                                <a href="<?php echo e(route('tasks.show', $task)); ?>" class="btn btn-sm btn-outline-primary" title="View">
                                    <i class="bi bi-eye"></i>
                                </a>

                                
                                <?php if($task->assigned_to === auth()->id() || auth()->user()->canManageTasks()): ?>
                                    <?php if($task->status === 'pending'): ?>
                                    <form action="<?php echo e(route('tasks.start', $task)); ?>" method="POST">
                                        <?php echo csrf_field(); ?> <?php echo method_field('PATCH'); ?>
                                        <button class="btn btn-sm btn-success" title="Start Task">
                                            <i class="bi bi-play-fill"></i>
                                        </button>
                                    </form>
                                    <?php elseif($task->status === 'in_progress'): ?>
                                    <form action="<?php echo e(route('tasks.complete', $task)); ?>" method="POST">
                                        <?php echo csrf_field(); ?> <?php echo method_field('PATCH'); ?>
                                        <button class="btn btn-sm btn-warning" title="Mark Complete">
                                            <i class="bi bi-stop-fill"></i>
                                        </button>
                                    </form>
                                    <?php elseif($task->status === 'rejected'): ?>
                                    <form action="<?php echo e(route('tasks.start', $task)); ?>" method="POST">
                                        <?php echo csrf_field(); ?> <?php echo method_field('PATCH'); ?>
                                        <button class="btn btn-sm btn-primary" title="Re-start Task">
                                            <i class="bi bi-arrow-repeat"></i>
                                        </button>
                                    </form>
                                    <?php endif; ?>
                                <?php endif; ?>

                                <?php if(!in_array($task->status, ['approved', 'completed'])): ?>
                                <a href="<?php echo e(route('tasks.edit', $task)); ?>" class="btn btn-sm btn-outline-secondary" title="Edit">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                <?php endif; ?>
                                <?php if(auth()->user()->canManageTasks()): ?>
                                <form action="<?php echo e(route('tasks.destroy', $task)); ?>" method="POST"
                                      onsubmit="return confirm('Are you sure you want to delete this task?')">
                                    <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                    <button class="btn btn-sm btn-outline-danger" title="Delete">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </form>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="9" class="text-center text-muted py-5">
                            <i class="bi bi-inbox display-6 d-block mb-2 opacity-50"></i>
                            No tasks found.
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <?php if($tasks->hasPages()): ?>
    <div class="card-footer">
        <?php echo e($tasks->links()); ?>

    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH H:\xampp_8.0\htdocs\user_task\resources\views/tasks/index.blade.php ENDPATH**/ ?>