@extends('layouts.app')

@section('title', 'My Profile')
@section('page-title', 'My Profile')

@section('content')
<div class="row justify-content-center">
    <div class="col-lg-6 col-md-8">

        {{-- Profile Card --}}
        <div class="card mb-4">
            <div class="card-header py-3 d-flex align-items-center gap-3">
                {{-- Avatar circle --}}
                <div style="width:52px;height:52px;border-radius:50%;background:linear-gradient(135deg,#6366f1,#8b5cf6);
                            display:flex;align-items:center;justify-content:center;
                            font-size:1.3rem;font-weight:700;color:#fff;">
                    {{ strtoupper(substr(auth()->user()->name, 0, 1)) }}
                </div>
                <div>
                    <h6 class="mb-0 fw-bold">{{ auth()->user()->name }}</h6>
                    <span class="role-badge role-{{ auth()->user()->role }}">
                        {{ str_replace('_', ' ', auth()->user()->role) }}
                    </span>
                </div>
            </div>
            <div class="card-body">

                {{-- Read-only info --}}
                <div class="row g-3 mb-4">
                    <div class="col-sm-6">
                        <label class="form-label text-muted small fw-semibold">Full Name</label>
                        <div class="form-control bg-light text-muted">{{ auth()->user()->name }}</div>
                    </div>
                    <div class="col-sm-6">
                        <label class="form-label text-muted small fw-semibold">Email Address</label>
                        <div class="form-control bg-light text-muted">{{ auth()->user()->email }}</div>
                    </div>
                    <div class="col-sm-6">
                        <label class="form-label text-muted small fw-semibold">Username</label>
                        <div class="form-control bg-light text-muted">{{ auth()->user()->username ?? '—' }}</div>
                    </div>
                    <div class="col-sm-6">
                        <label class="form-label text-muted small fw-semibold">Role</label>
                        <div class="form-control bg-light text-muted text-capitalize">{{ str_replace('_', ' ', auth()->user()->role) }}</div>
                    </div>
                </div>

                <hr class="my-3">

                {{-- Editable Form --}}
                <form action="{{ route('profile.update') }}" method="POST" id="profileForm">
                    @csrf
                    @method('PUT')

                    <h6 class="fw-semibold mb-3 text-dark">
                        <i class="bi bi-pencil-square me-1 text-primary"></i> Update Profile
                    </h6>

                    {{-- Phone --}}
                    <div class="mb-3">
                        <label class="form-label fw-semibold" for="phone">
                            <i class="bi bi-telephone me-1 text-muted"></i> Phone Number
                        </label>
                        <input type="text" class="form-control @error('phone') is-invalid @enderror"
                               id="phone" name="phone"
                               value="{{ old('phone', auth()->user()->phone) }}"
                               placeholder="e.g. 0300-1234567" maxlength="20">
                        @error('phone')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <hr class="my-3">
                    <h6 class="fw-semibold mb-3 text-dark">
                        <i class="bi bi-shield-lock me-1 text-primary"></i> Change Password
                        <small class="text-muted fw-normal">(leave blank to keep current)</small>
                    </h6>

                    {{-- Current Password --}}
                    <div class="mb-3">
                        <label class="form-label fw-semibold" for="current_password">Current Password</label>
                        <div class="input-group">
                            <input type="password" class="form-control @error('current_password') is-invalid @enderror"
                                   id="current_password" name="current_password"
                                   placeholder="Enter current password">
                            <button class="btn btn-outline-secondary" type="button"
                                    onclick="togglePwd('current_password', this)">
                                <i class="bi bi-eye"></i>
                            </button>
                            @error('current_password')
                            <div class="invalid-feedback d-block">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    {{-- New Password --}}
                    <div class="mb-3">
                        <label class="form-label fw-semibold" for="new_password">New Password</label>
                        <div class="input-group">
                            <input type="password" class="form-control @error('new_password') is-invalid @enderror"
                                   id="new_password" name="new_password"
                                   placeholder="Minimum 6 characters">
                            <button class="btn btn-outline-secondary" type="button"
                                    onclick="togglePwd('new_password', this)">
                                <i class="bi bi-eye"></i>
                            </button>
                            @error('new_password')
                            <div class="invalid-feedback d-block">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    {{-- Confirm Password --}}
                    <div class="mb-4">
                        <label class="form-label fw-semibold" for="new_password_confirmation">Confirm New Password</label>
                        <div class="input-group">
                            <input type="password" class="form-control"
                                   id="new_password_confirmation" name="new_password_confirmation"
                                   placeholder="Repeat new password">
                            <button class="btn btn-outline-secondary" type="button"
                                    onclick="togglePwd('new_password_confirmation', this)">
                                <i class="bi bi-eye"></i>
                            </button>
                        </div>
                    </div>

                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary px-4">
                            <i class="bi bi-check-lg me-1"></i> Save Changes
                        </button>
                        <a href="{{ route('dashboard') }}" class="btn btn-outline-secondary px-4">Cancel</a>
                    </div>
                </form>

            </div>
        </div>

    </div>
</div>
@endsection

@section('scripts')
<script>
function togglePwd(fieldId, btn) {
    const input = document.getElementById(fieldId);
    const isPassword = input.type === 'password';
    input.type = isPassword ? 'text' : 'password';
    btn.innerHTML = isPassword ? '<i class="bi bi-eye-slash"></i>' : '<i class="bi bi-eye"></i>';
}
</script>
@endsection
