@extends('layouts.app')

@section('title', 'All Notifications')
@section('page-title', 'Notifications')

@section('content')
<div class="row">
    <div class="col-lg-8 col-md-10">

        <div class="card">
            <div class="card-header py-3 d-flex justify-content-between align-items-center">
                <h6 class="mb-0 fw-bold">
                    <i class="bi bi-bell me-2 text-primary"></i> All Notifications
                </h6>
                @php $unread = $notifications->getCollection()->where('read_at', null)->count(); @endphp
                @if($unread > 0)
                <span class="badge bg-danger">{{ $unread }} unread</span>
                @else
                <span class="badge bg-success">All caught up!</span>
                @endif
            </div>
            <div class="card-body p-0">
                @forelse($notifications as $notif)
                <div class="d-flex gap-3 px-4 py-3 border-bottom {{ $notif->isRead() ? '' : 'bg-primary bg-opacity-10' }}">
                    {{-- Icon --}}
                    <div class="flex-shrink-0 mt-1">
                        <div style="width:38px;height:38px;border-radius:50%;background:{{ $notif->isRead() ? '#f0f0f0' : '#e8eeff' }};
                                    display:flex;align-items:center;justify-content:center;">
                            <i class="bi {{ $notif->iconClass() }}" style="font-size:1rem;"></i>
                        </div>
                    </div>

                    {{-- Content --}}
                    <div class="flex-grow-1">
                        <div class="d-flex justify-content-between align-items-start">
                            <div>
                                <span class="fw-semibold text-dark" style="font-size:0.875rem;">{{ $notif->title }}</span>
                                @if(!$notif->isRead())
                                <span class="badge bg-primary ms-1" style="font-size:0.6rem;">New</span>
                                @endif
                            </div>
                            <small class="text-muted flex-shrink-0 ms-3">{{ $notif->created_at->diffForHumans() }}</small>
                        </div>
                        <p class="text-muted mb-1" style="font-size:0.825rem;">{{ $notif->message }}</p>
                        <small class="text-muted" style="font-size:0.75rem;">{{ $notif->created_at->format('d M Y, h:i A') }}</small>

                        {{-- Link to task if available --}}
                        @if(!empty($notif->data['task_id']))
                        <div class="mt-1">
                            <a href="{{ route('tasks.show', $notif->data['task_id']) }}"
                               class="btn btn-sm btn-outline-primary py-0 px-2" style="font-size:0.75rem;">
                                <i class="bi bi-arrow-right me-1"></i> View Task
                            </a>
                        </div>
                        @endif
                    </div>
                </div>
                @empty
                <div class="text-center py-5 text-muted">
                    <i class="bi bi-bell-slash d-block mb-2" style="font-size:2.5rem;"></i>
                    <p class="mb-0">No notifications yet.</p>
                    <small>You'll see updates here when tasks are assigned or reviewed.</small>
                </div>
                @endforelse
            </div>

            @if($notifications->hasPages())
            <div class="card-footer bg-white d-flex justify-content-center py-3">
                {{ $notifications->links() }}
            </div>
            @endif
        </div>

    </div>
</div>
@endsection
