@extends('layouts.app')
@section('title', 'Admin Dashboard')
@section('page-title', 'Admin Dashboard')

@section('content')
<!-- Stats Cards -->
<div class="row g-3 mb-4">
    <div class="col-md-2">
        <div class="stat-card bg-white h-100">
            <div class="d-flex align-items-center justify-content-between">
                <div>
                    <div class="text-muted small mb-1">Total Tasks</div>
                    <div class="fw-bold fs-3">{{ $stats['total_tasks'] }}</div>
                </div>
                <div class="stat-icon" style="background:#e0e7ff;color:#6366f1;">
                    <i class="bi bi-list-task"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-2">
        <div class="stat-card bg-white h-100">
            <div class="d-flex align-items-center justify-content-between">
                <div>
                    <div class="text-muted small mb-1">Pending</div>
                    <div class="fw-bold fs-3 text-secondary">{{ $stats['pending'] }}</div>
                </div>
                <div class="stat-icon" style="background:#f1f5f9;color:#64748b;">
                    <i class="bi bi-hourglass"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-2">
        <div class="stat-card bg-white h-100">
            <div class="d-flex align-items-center justify-content-between">
                <div>
                    <div class="text-muted small mb-1">In Progress</div>
                    <div class="fw-bold fs-3 text-primary">{{ $stats['in_progress'] }}</div>
                </div>
                <div class="stat-icon" style="background:#dbeafe;color:#2563eb;">
                    <i class="bi bi-play-circle"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-2">
        <div class="stat-card bg-white h-100">
            <div class="d-flex align-items-center justify-content-between">
                <div>
                    <div class="text-muted small mb-1">Under Review</div>
                    <div class="fw-bold fs-3 text-warning">{{ $stats['under_review'] }}</div>
                </div>
                <div class="stat-icon" style="background:#fef9c3;color:#ca8a04;">
                    <i class="bi bi-eye"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-2">
        <div class="stat-card bg-white h-100">
            <div class="d-flex align-items-center justify-content-between">
                <div>
                    <div class="text-muted small mb-1">Completed</div>
                    <div class="fw-bold fs-3 text-success">{{ $stats['completed'] }}</div>
                </div>
                <div class="stat-icon" style="background:#dcfce7;color:#16a34a;">
                    <i class="bi bi-check-circle"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-2">
        <div class="stat-card bg-white h-100">
            <div class="d-flex align-items-center justify-content-between">
                <div>
                    <div class="text-muted small mb-1">Team Members</div>
                    <div class="fw-bold fs-3 text-info">{{ $stats['total_users'] }}</div>
                </div>
                <div class="stat-icon" style="background:#cffafe;color:#0891b2;">
                    <i class="bi bi-people"></i>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row g-3">
    <!-- Team Performance -->
    <div class="col-md-5">
        <div class="card h-100">
            <div class="card-header d-flex justify-content-between align-items-center py-3">
                <span><i class="bi bi-people me-2 text-primary"></i>Team Performance</span>
                <a href="{{ route('users.index') }}" class="btn btn-sm btn-outline-primary">View All</a>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table mb-0">
                        <thead>
                            <tr>
                                <th class="ps-3">Member</th>
                                <th>Role</th>
                                <th>Total</th>
                                <th>Done</th>
                                <th>Progress</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($teamMembers as $member)
                            <tr>
                                <td class="ps-3">
                                    <div class="d-flex align-items-center gap-2">
                                        <div class="avatar">{{ strtoupper(substr($member->name, 0, 1)) }}</div>
                                        <span class="fw-medium">{{ $member->name }}</span>
                                    </div>
                                </td>
                                <td>
                                    <span class="role-badge role-{{ $member->role }}">
                                        {{ str_replace('_', ' ', $member->role) }}
                                    </span>
                                </td>
                                <td>{{ $member->assigned_tasks_count }}</td>
                                <td>{{ $member->completed_tasks_count }}</td>
                                <td style="width:80px;">
                                    @php
                                        $percent = $member->assigned_tasks_count > 0
                                            ? round(($member->completed_tasks_count / $member->assigned_tasks_count) * 100)
                                            : 0;
                                    @endphp
                                    <div class="progress" style="height:6px;">
                                        <div class="progress-bar bg-success" style="width:{{ $percent }}%"></div>
                                    </div>
                                    <small class="text-muted">{{ $percent }}%</small>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Tasks -->
    <div class="col-md-7">
        <div class="card h-100">
            <div class="card-header d-flex justify-content-between align-items-center py-3">
                <span><i class="bi bi-clock me-2 text-warning"></i>Recent Tasks</span>
                <a href="{{ route('tasks.index') }}" class="btn btn-sm btn-outline-primary">View All</a>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table mb-0">
                        <thead>
                            <tr>
                                <th class="ps-3">Task</th>
                                <th>Assigned To</th>
                                <th>Priority</th>
                                <th>Due Date</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($recentTasks as $task)
                            <tr>
                                <td class="ps-3">
                                    <a href="{{ route('tasks.show', $task) }}" class="text-decoration-none fw-medium">
                                        {{ Str::limit($task->title, 30) }}
                                    </a>
                                </td>
                                <td>
                                    <div class="d-flex align-items-center gap-1">
                                        <div class="avatar" style="width:24px;height:24px;font-size:0.65rem;">
                                            {{ strtoupper(substr($task->assignedUser->name, 0, 1)) }}
                                        </div>
                                        <span class="small">{{ $task->assignedUser->name }}</span>
                                    </div>
                                </td>
                                <td>
                                    <span class="badge bg-{{ $task->priorityBadge() }}">{{ $task->priority }}</span>
                                </td>
                                <td>
                                    <span class="small {{ $task->isOverdue() ? 'text-danger fw-bold' : 'text-muted' }}">
                                        {{ $task->planned_end->format('d M Y') }}
                                    </span>
                                </td>
                                <td>
                                    <span class="badge status-{{ $task->status }}">
                                        {{ str_replace('_', ' ', ucfirst($task->status)) }}
                                    </span>
                                </td>
                            </tr>
                            @empty
                            <tr><td colspan="5" class="text-center text-muted py-4">No tasks yet.</td></tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Gantt Chart Style Timeline -->
<div class="card mt-3">
    <div class="card-header py-3">
        <i class="bi bi-bar-chart-steps me-2 text-info"></i>Task Timeline Overview
    </div>
    <div class="card-body">
        @if($allTasks->count())
        <div class="table-responsive">
            <table class="table table-sm">
                <thead>
                    <tr>
                        <th style="width:200px;">Task</th>
                        <th style="width:100px;">Assigned To</th>
                        <th style="width:90px;">Start</th>
                        <th style="width:90px;">End</th>
                        <th>Progress Timeline</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($allTasks as $task)
                    <tr>
                        <td>
                            <a href="{{ route('tasks.show', $task) }}" class="text-decoration-none small fw-medium">
                                {{ Str::limit($task->title, 25) }}
                            </a>
                        </td>
                        <td><small class="text-muted">{{ $task->assignedUser->name }}</small></td>
                        <td><small>{{ $task->planned_start->format('d M') }}</small></td>
                        <td>
                            <small class="{{ $task->isOverdue() ? 'text-danger fw-bold' : '' }}">
                                {{ $task->planned_end->format('d M') }}
                            </small>
                        </td>
                        <td>
                            @php
                                $total = $task->planned_start->diffInDays($task->planned_end) + 1;
                                $elapsed = $task->planned_start->diffInDays(now()) + 1;
                                $elapsed = min($elapsed, $total);
                                $elapsed = max($elapsed, 0);
                                $pct = $total > 0 ? round(($elapsed / $total) * 100) : 0;
                                $colors = ['pending'=>'secondary','in_progress'=>'primary','under_review'=>'warning','approved'=>'success','rejected'=>'danger','completed'=>'dark'];
                                $color = $colors[$task->status] ?? 'secondary';
                            @endphp
                            <div class="progress" style="height:18px;border-radius:4px;">
                                <div class="progress-bar bg-{{ $color }}" style="width:{{ $pct }}%;font-size:0.7rem;">
                                    {{ $pct }}%
                                </div>
                            </div>
                        </td>
                        <td>
                            <span class="badge status-{{ $task->status }} small">
                                {{ str_replace('_', ' ', ucfirst($task->status)) }}
                            </span>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        @else
        <p class="text-muted text-center py-3">No tasks found.</p>
        @endif
    </div>
</div>
@endsection
