<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $fillable = [
        'name',
        'email',
        'username',
        'password',
        'role',
        'phone',
        'avatar',
        'status',
    ];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    // Role check helpers
    public function isSuperAdmin(): bool { return $this->role === 'super_admin'; }
    public function isAdmin(): bool      { return $this->role === 'admin'; }
    public function isMarketing(): bool  { return $this->role === 'marketing'; }
    public function isDesigner(): bool   { return $this->role === 'designer'; }
    public function isDeveloper(): bool  { return $this->role === 'developer'; }
    public function canManageTasks(): bool  { return in_array($this->role, ['super_admin', 'admin']); }
    public function canAssignTasks(): bool  { return in_array($this->role, ['super_admin', 'admin', 'marketing']); }
    public function canApprove(): bool      { return in_array($this->role, ['super_admin', 'admin', 'marketing']); }

    // Relationships
    public function assignedTasks()
    {
        return $this->hasMany(Task::class, 'assigned_to');
    }

    public function createdTasks()
    {
        return $this->hasMany(Task::class, 'created_by');
    }

    public function taskLogs()
    {
        return $this->hasMany(TaskLog::class, 'user_id');
    }

    public function approvals()
    {
        return $this->hasMany(TaskApproval::class, 'reviewed_by');
    }
}
