<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TaskLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'task_id',
        'user_id',
        'action',
        'note',
    ];

    // Action label helper
    public function actionLabel(): string
    {
        return match($this->action) {
            'created'        => 'Task Created',
            'started'        => 'Task Started',
            'completed'      => 'Marked as Complete',
            'submitted'      => 'Submitted for Review',
            'approved'       => 'Approved',
            'rejected'       => 'Rejected',
            'updated'        => 'Task Updated',
            'assigned'       => 'Task Assigned',
            default          => ucfirst($this->action),
        };
    }

    // Action badge color
    public function actionBadge(): string
    {
        return match($this->action) {
            'created'        => 'info',
            'started'        => 'primary',
            'completed'      => 'success',
            'submitted'      => 'warning',
            'approved'       => 'success',
            'rejected'       => 'danger',
            'updated'        => 'secondary',
            'assigned'       => 'dark',
            default          => 'secondary',
        };
    }

    // Relationships
    public function task()
    {
        return $this->belongsTo(Task::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
