<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Notification extends Model
{
    protected $fillable = [
        'user_id', 'type', 'title', 'message', 'data', 'read_at',
    ];

    protected $casts = [
        'data'    => 'array',
        'read_at' => 'datetime',
    ];

    // ─── Relationships ────────────────────────────────────────────────────────

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // ─── Helpers ──────────────────────────────────────────────────────────────

    public function isRead(): bool
    {
        return $this->read_at !== null;
    }

    public function markRead(): void
    {
        if (!$this->read_at) {
            $this->update(['read_at' => now()]);
        }
    }

    public function iconClass(): string
    {
        return match ($this->type) {
            'task_assigned'  => 'bi-person-check-fill text-primary',
            'task_started'   => 'bi-play-circle-fill text-info',
            'task_submitted' => 'bi-send-fill text-warning',
            'task_approved'  => 'bi-check-circle-fill text-success',
            'task_rejected'  => 'bi-x-circle-fill text-danger',
            'task_restarted' => 'bi-arrow-clockwise text-secondary',
            default          => 'bi-bell-fill text-secondary',
        };
    }

    public function bgClass(): string
    {
        return $this->isRead() ? '' : 'bg-light';
    }
}
